unit EngineImgScale01;

interface

uses
  Windows, Messages, Controls, Classes, SysUtils, Graphics, ExtCtrls,
  Dialogs, EngineMainData01;

// ========================================================================
//      TImage.
// ========================================================================
//   TImageScale
const MaxWH   = 6000;     //  NewHeight  NewWidth
      MinZoom = 0.01;     //  Zoom
      MaxZoom = 8;        //  Zoom
//
type TImageScale = class(TObject)
  private
    fImgSrc  : TImage;    // Image  
    fImgTrg  : TImage;    // Image   
    fZoom    : double;    // Zoom  (MinZoom ... MaxZoom)
    fSrcH    : integer;   //   
    fSrcW    : integer;   //   
    fNewH    : integer;   //   
    fNewW    : integer;   //   
    fProport : boolean;   //   
    fCorrYes : boolean;   //    Zoom  
    fBitMap  : TBitmap;   //  BitMap
    // ----------------
    //     
    procedure GetImgSrcHW();
    //  property
    procedure SetImgSrc(RqImg : TImage);
    procedure SetZoom(RqZoom : double);
    procedure SetNewHeight(RqHeight : integer);
    procedure SetNewWidth(RqWidth : integer);
    // ----------------
    //   
    procedure NormNewHW();
    // ----------------
  public
    constructor Create();
    procedure Free();
    // ----------------
    //  
    procedure RunScaleHW();
    // ----------------
    property ImageSrc     : TImage  read fImgSrc  write SetImgSrc;
    property ImageTrg     : TImage  read fImgTrg  write fImgTrg;
    property Proportional : boolean read fProport write fProport;
    property Zoom         : double  read fZoom    write SetZoom;
    property SrcHeight    : integer read fSrcH;
    property SrcWidth     : integer read fSrcW;
    property NewHeight    : integer read fNewH    write SetNewHeight;
    property NewWidth     : integer read fNewW    write SetNewWidth;
    property CorrYes      : boolean read fCorrYes;
end;

// ------------------------------------------------------------------------

procedure GetBitMapFromImage (RqImg    : TImage;
                              RqRec    : TRect;
                              RqBitMap : TBitMap); overload;

procedure GetBitMapFromImage (RqImg    : TImage;
                              RqX, RqY : integer;
                              RqHW     : integer;
                              RqBitMap : TBitMap); overload;
// ------------------------------------------------------------------------
procedure SetImgHW (RqImg : TImage; RqHeight, RqWidth : integer);
// ------------------------------------------------------------------------
procedure SetBitMapToImage (RqImg    : TImage;
                            RqX, RqY : integer;
                            RqBitMap : TBitMap);
// ------------------------------------------------------------------------

implementation

// ========================================================================
//      TImage.
// ========================================================================
// ------------------------------------------------------------------------
//  
constructor TImageScale.Create();
begin
  inherited Create;
  fProport := True;
  fBitMap  := TBitmap.Create;
  fBitMap.PixelFormat := pf24bit;
end;
// ------------------------------------------------------------------------
//  
procedure TImageScale.Free();
begin
  fBitMap.Free;
  inherited;
end;
// ------------------------------------------------------------------------
//   Zoom  
procedure ZoomMessage();
var Min, Max : double;
begin
  Min := 100 * MinZoom;
  Max := 100 * MaxZoom;
  MessageDlg('Zoom  :'
             + #13#10
             + '( '
             + format('%4.1f', [Min])
             + ' ... '
             + format('%4.1f', [Max])
             + ' ) %'
             + #13#10
             + '  ',
                mtWarning, [mbOk], 0);
end;
// ------------------------------------------------------------------------
//   NewHeight  NewWidth  
procedure MaxWHMessage();
begin
  MessageDlg('     :'
             + #13#10
             + '( 1 ... '
             + IntToStr(MaxWH)
             + ' ) '
             + #13#10
             + '  ',
                mtWarning, [mbOk], 0);
end;
// ------------------------------------------------------------------------
//   Height  Width   
//      (1...MaxWH)
procedure TImageScale.NormNewHW();
begin
    //       
    if (fNewW > MaxWH) or (fNewH > MaxWH)
    then begin
       if (fNewW > fNewH)
       then begin
         //       
         fNewH := Round((fNewH/fNewW) * MaxWH);
         fNewW := MaxWH;
       end;
       if (fNewW < fNewH)
       then begin
         //       
         fNewW := Round((fNewW/fNewH) * MaxWH);
         fNewH := MaxWH;
       end;
       fCorrYes := True;
       //   NewHeight  NewWidth  
       MaxWHMessage();
    end
    else fCorrYes := False;
    //      
    if (fNewW < 1) then fNewW := 1;
    if (fNewH < 1) then fNewH := 1;
end;
// ------------------------------------------------------------------------
//     
procedure TImageScale.GetImgSrcHW();
begin
   if Assigned(fImgSrc)
   then begin
     //  
     fSrcH := fImgSrc.Picture.Bitmap.Height;
     fSrcW := fImgSrc.Picture.Bitmap.Width;
   end
   else begin
     fSrcH := 0;
     fSrcW := 0;
   end;
end;
// ------------------------------------------------------------------------
procedure TImageScale.SetImgSrc(RqImg : TImage);
begin
   if Assigned(RqImg)
   then begin
     fImgSrc := RqImg;
     GetImgSrcHW();  //     
   end else fImgSrc := nil;
end;
// ------------------------------------------------------------------------
procedure TImageScale.SetZoom(RqZoom : double);
begin
   if not Assigned(fImgSrc) then Exit;
   GetImgSrcHW();  //     
   fZoom := RqZoom;
   fCorrYes := False;
   if (fZoom < MinZoom)
   then begin
       fZoom := MinZoom;
       fCorrYes := True;
       ZoomMessage();
   end;
   if (fZoom > 8)
   then begin
       fCorrYes := True;
       fZoom := MaxZoom;
       ZoomMessage();
   end;
   // Zoom     
   fNewH := Round(fSrcH * fZoom);
   fNewW := Round(fSrcW * fZoom);
   NormNewHW();
end;
// ------------------------------------------------------------------------
//          
procedure TImageScale.SetNewHeight(RqHeight : integer);
begin
   if not Assigned(fImgSrc) then Exit;
   GetImgSrcHW();  //     
   //    (1...MaxWH)
   if RqHeight <= MaxWH
   then begin
       fNewH := RqHeight;
       fCorrYes := False;
   end
   else begin
      //  
      fNewH := MaxWH;
      fCorrYes := True;
      MaxWHMessage();
   end;
   if (fNewH < 1) then fNewH := 1;
   //   
   if fProport
   then begin
      fNewW := Round((fNewH / fSrcH) * fSrcW);
      if fNewW > MaxWH then NormNewHW();
   end;
end;
// ------------------------------------------------------------------------
//          
procedure TImageScale.SetNewWidth(RqWidth : integer);
begin
   if not Assigned(fImgSrc) then Exit;
   GetImgSrcHW();  //     
   //    (1...MaxWH)
   if RqWidth <= MaxWH
   then begin
      fNewW := RqWidth;
      fCorrYes := False;
   end
   else begin
      //  
      fNewW := MaxWH;
      fCorrYes := True;
      MaxWHMessage();
   end;
   if (fNewW < 1) then fNewW := 1;
   //   
   if fProport
   then begin
      fNewH := Round((fNewW / fSrcW) * fSrcH);
      if fNewH > MaxWH then NormNewHW();
   end;
end;
// ------------------------------------------------------------------------
//  
procedure TImageScale.RunScaleHW();
begin
  if not (Assigned(fImgSrc) and Assigned(fImgTrg)) then Exit;
  if (fSrcH = 0) or (fSrcW = 0) then Exit;
  if (fSrcH <> fNewH) or (fSrcW <> fNewW)
  then begin
    fBitMap.Height := fNewH;
    fBitMap.Width  := fNewW;
    SetStretchBltMode(fBitMap.Canvas.Handle, HALFTONE);
    StretchBlt(fBitMap.Canvas.Handle,                 // 
               0, 0, fNewW, fNewH,
               fImgSrc.Picture.Bitmap.Canvas.Handle,  // 
               0, 0, fSrcW, fSrcH,
               SRCCOPY);
  end
  else begin
     fBitMap.Height := fNewH;
     fBitMap.Width  := fNewW;
     BitBlt(fBitMap.Canvas.Handle,                     // 
               0, 0, fNewW, fNewH,
               fImgSrc.Picture.Bitmap.Canvas.Handle,   // 
               0, 0, SRCCOPY);
  end;
  fImgTrg.Picture.Bitmap.Assign(fBitMap);
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
procedure GetBitMapFromImage (RqImg    : TImage;
                              RqRec    : TRect;
                              RqBitMap : TBitMap); overload;
begin
   if not (Assigned(RqImg) and Assigned(RqBitMap)) then Exit;
   if not ((RqRec.Right > RqRec.Left) and (RqRec.Bottom > RqRec.Top)) then Exit;
   RqBitMap.Height := RqRec.Bottom - RqRec.Top;
   RqBitMap.Width  := RqRec.Right - RqRec.Left;
   BitBlt(RqBitMap.Canvas.Handle,                      // 
          0, 0, RqRec.Right - RqRec.Left, RqRec.Bottom - RqRec.Top,
          RqImg.Picture.Bitmap.Canvas.Handle,          // 
          RqRec.Left, RqRec.Top, SRCCOPY);
end;
procedure GetBitMapFromImage (RqImg    : TImage;
                              RqX, RqY : integer;
                              RqHW     : integer;
                              RqBitMap : TBitMap); overload;
var Rect : TRect;
begin
   Rect.Left  := RqX;
   Rect.Top   := RqY;
   Rect.Right :=  RqX + Abs(RqHW);
   Rect.Bottom := RqY + Abs(RqHW);
   GetBitMapFromImage (RqImg, Rect, RqBitMap);
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
procedure SetImgHW (RqImg : TImage; RqHeight, RqWidth : integer);
begin
   if not Assigned(RqImg) then Exit;
   if not ((RqHeight > 0) and (RqWidth > 0)) then Exit;
   RqImg.Picture.Bitmap.Height := RqHeight;
   RqImg.Picture.Bitmap.Width  := RqWidth;
end;
// ------------------------------------------------------------------------
procedure SetBitMapToImage (RqImg    : TImage;
                            RqX, RqY : integer;
                            RqBitMap : TBitMap);
var H, W : integer;
begin
   if not (Assigned(RqImg) and Assigned(RqBitMap)) then Exit;
   H := RqBitMap.Height;
   W := RqBitMap.Width;
   if not ((H > 0) and (W > 0)) then Exit;
   BitBlt(RqImg.Picture.Bitmap.Canvas.Handle,   // 
          RqX, RqY, RqX + W, RqY + H,
          RqBitMap.Canvas.Handle,               // 
          0, 0, SRCCOPY);
end;
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------
// ------------------------------------------------------------------------


end.
